<?php
// Minimal schema helpers for pricing-related tables

require_once __DIR__ . '/../config.php';

/**
 * Ensure the plan_prices table exists with the right key so
 * per-server pricing (plan_id, server_id -> price) works and
 * INSERT ... ON DUPLICATE KEY updates behave correctly.
 */
function ensure_pricing_schema(mysqli $connect): void {
    // Create plan_prices if missing
    $connect->query(
        "CREATE TABLE IF NOT EXISTS plan_prices (
            plan_id INT NOT NULL,
            server_id INT NOT NULL,
            price INT NULL,
            PRIMARY KEY (plan_id, server_id),
            INDEX idx_server_id (server_id)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci"
    );

    // Best-effort: in case an older table exists without a PK/unique key,
    // try to add a unique index to enable ON DUPLICATE KEY behavior.
    try {
        $connect->query("ALTER TABLE plan_prices ADD UNIQUE KEY uq_plan_server (plan_id, server_id)");
    } catch (Throwable $e) {
        // ignore if already present or conflicts
    }
}
