<?php
ob_start();
require_once __DIR__ . '/config.php';

// Config moved to config.php
$connect = db_connect();
$token = BOT_TOKEN;
if (!defined('API_KEY')) {
    define('API_KEY', BOT_TOKEN);
}

if (!function_exists('h')) {
    function h($s) {
        return htmlspecialchars((string)$s, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8');
    }
}
//------------------------------------------------------------------------------
if (!function_exists('bot')) {
function bot($method,$datas=[]){ // فانکشن اصلی ربات
    $url = "https://api.telegram.org/bot".API_KEY."/".$method;
    $ch = curl_init();
    // Avoid Telegram Markdown parse errors by dropping legacy 'markdown'
    if (isset($datas['parse_mode']) && is_string($datas['parse_mode']) && strtolower($datas['parse_mode']) === 'markdown') {
        unset($datas['parse_mode']);
    }
    curl_setopt($ch,CURLOPT_URL,$url);
    curl_setopt($ch,CURLOPT_RETURNTRANSFER,true);
    curl_setopt($ch,CURLOPT_POSTFIELDS,$datas);
    curl_setopt($ch,CURLOPT_CONNECTTIMEOUT, 10);
    curl_setopt($ch,CURLOPT_TIMEOUT, 20);
    if (defined('DISABLE_SSL_VERIFY') && DISABLE_SSL_VERIFY) {
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    }
    $res = curl_exec($ch);
    if($res === false){
        error_log('Telegram cURL error: '.curl_error($ch));
        curl_close($ch);
        return null;
    }
    curl_close($ch);
    return json_decode($res,true);
}
}

function deleteMessage($chatid,$msgid){ //فانکشن ارسال پیام
	return bot('deleteMessage',[
	'chat_id'=>$chatid,
	'message_id'=>$msgid,
	]);
	}
//▪▪▪▪▪▪▪▪▪▪▪▪//
function SendMessage($chatid,$text,$keyboard=null,$pars='html'){ //فانکشن ارسال پیام
	return bot('sendMessage',[
	'chat_id'=>$chatid,
	'text'=>$text,
	'reply_markup'=>$keyboard,
	'parse_mode'=>$pars,
	'disable_web_page_preview'=>true 
	]);
	}
	function editMessageText($chat_id, $message_id, $text, $keyboard = null, $pars = 'html') {
    return bot('editMessageText', [
        'chat_id' => $chat_id,
        'message_id' => $message_id,
        'text' => $text,
        'reply_markup' => $keyboard,
        'parse_mode' => $pars,
        'disable_web_page_preview' => true
    ]);
}
	function editMessageCaption($chat_id, $message_id, $text, $keyboard = null, $pars = 'html') {
    return bot('editMessageCaption', [
        'chat_id' => $chat_id,
        'message_id' => $message_id,
        'caption' => $text,
        'reply_markup' => $keyboard,
        'parse_mode' => $pars,
        'disable_web_page_preview' => true
    ]);
}
function updateVlessLink(string $originalLink, string $newUuid, string $newRemark): string {
    // حذف vless:// از اول لینک
    $linkWithoutScheme = substr($originalLink, 8); // حذف vless://

    // جدا کردن بخش‌های اصلی: [uuid@host:port]?[params]#[remark]
    $parts = explode('#', $linkWithoutScheme, 2);
    $beforeHash = $parts[0];
    $oldRemark = $parts[1] ?? '';

    // حالا uuid رو جدا کنیم: uuid@host:port
    $atParts = explode('@', $beforeHash, 2);
    if (count($atParts) < 2) {
        return "لینک نامعتبر است.";
    }

    $newBeforeHash = $newUuid . '@' . $atParts[1];

    // لینک نهایی رو دوباره می‌سازیم
    $updatedLink = 'vless://' . $newBeforeHash . '#' . urlencode($newRemark);

    return $updatedLink;
}

//▪▪▪▪▪▪▪▪▪▪▪▪//
function ForwardMessage($chatid,$from_chat,$message_id){ //فانکشن فروارد پیام
	bot('ForwardMessage',[
	'chat_id'=>$chatid,
	'from_chat_id'=>$from_chat,
	'message_id'=>$message_id
	]);
	}
//▪▪▪▪▪▪▪▪▪▪▪▪//
function SendPhoto($chat_id, $photo, $caption = null, $reply_markup = null){ // فانکشن ارسال عکس
	bot('SendPhoto',[
	'chat_id'=>$chat_id,
	'photo'=>$photo,
	'caption'=>$caption,
	'reply_markup'=>$reply_markup
	]);
}
function sendDocument($chat_id, $document_path, $caption = null, $pars = 'html'){
    $datas = [
        'chat_id' => $chat_id,
        'document' => new CURLFile(realpath($document_path)),
    ];
    if ($caption) {
        $datas['caption'] = $caption;
        $datas['parse_mode'] = $pars;
    }
    return bot('sendDocument', $datas);
}
function generateRandomString($length = 10) {
    $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $charactersLength = strlen($characters);
    $randomString = '';
    for ($i = 0; $i < $length; $i++) {
        $randomString .= $characters[random_int(0, $charactersLength - 1)];
    }
    return $randomString;
}
function getsv($url){
    $curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => $url,
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 5,
  CURLOPT_TIMEOUT => 20,
  CURLOPT_CONNECTTIMEOUT => 10,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'GET',
  CURLOPT_HTTPHEADER => array(
    'User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/123.0.0.0 Safari/537.36
'
  ),
));
if (defined('DISABLE_SSL_VERIFY') && DISABLE_SSL_VERIFY) {
    curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 0);
}

$response = curl_exec($curl);
if ($response === false) {
    error_log('getsv cURL error: '.curl_error($curl));
    curl_close($curl);
    return null;
}

curl_close($curl);
return $response;
}
	//▪▪▪▪▪▪▪▪▪▪▪▪//
function gen_uuid() {
    return sprintf( '%04x%04x-%04x-%04x-%04x-%04x%04x%04x',
        // 32 bits for "time_low"
        random_int( 0, 0xffff ), random_int( 0, 0xffff ),

        // 16 bits for "time_mid"
        random_int( 0, 0xffff ),

        // 16 bits for "time_hi_and_version",
        // four most significant bits holds version number 4
        random_int( 0, 0x0fff ) | 0x4000,

        // 16 bits, 8 bits for "clk_seq_hi_res",
        // 8 bits for "clk_seq_low",
        // two most significant bits holds zero and one for variant DCE1.1
        random_int( 0, 0x3fff ) | 0x8000,

        // 48 bits for "node"
        random_int( 0, 0xffff ), random_int( 0, 0xffff ), random_int( 0, 0xffff )
    );
}

//PANELS 

/**
 * کلاسی برای مدیریت ارتباط با پنل مرزبان
 */
class MarzbanClient {
    private $base_url;
    private $token;

    public function __construct(string $base_url, ?string $token = null) {
        $this->base_url = rtrim($base_url, '/');
        $this->token = $token;
    }

    public function getToken(): ?string {
        return $this->token;
    }

    private function request(string $path, string $method = 'GET', $payload = null, array $headers = []): array {
        $response = marzban_api_request($this->base_url, $path, $method, $this->token, $payload, $headers);
        if (!$response['success']) {
            $msg = $response['error_message'] ?? $response['error'] ?? 'unknown error';
            error_log(sprintf('MarzbanClient request failed [%s %s]: %s', strtoupper($method), $path, $msg));
        }
        return $response;
    }

    public function login(string $username, string $password): bool {
        $response = marzban_request_admin_token($this->base_url, $username, $password);

        if ($response['success'] && $response['token'] !== '') {
            $this->token = $response['token'];
            return true;
        }

        $error = $response['error_message'] ?? $response['error'] ?? 'unknown error';
        error_log('MarzbanClient login failed: ' . $error);
        return false;
    }

    public function getUser(string $username): ?array {
        $response = $this->request("/api/user/$username", 'GET');
        return $response['success'] ? $response['data'] : null;
    }

    public function createUser(string $username, array $proxies, int $data_limit, int $expire, array $extra = []): ?array {
        $payload = array_merge([
            'username' => $username,
            'proxies' => $proxies,
            'expire' => $expire,
            'data_limit' => $data_limit,
            'data_limit_reset_strategy' => 'no_reset',
        ], $extra);

        $response = $this->request('/api/user', 'POST', $payload);
        return $response['success'] ? $response['data'] : null;
    }

    public function updateUser(string $username, array $proxies, int $data_limit, int $expire, array $extra = []): ?array {
        $payload = array_merge([
            'username' => $username,
            'proxies' => $proxies,
            'expire' => $expire,
            'data_limit' => $data_limit,
            'data_limit_reset_strategy' => 'no_reset',
        ], $extra);

        $response = $this->request("/api/user/$username", 'PUT', $payload);
        return $response['success'] ? $response['data'] : null;
    }

    public function resetUser(string $username): bool {
        $response = $this->request("/api/user/$username/reset", 'POST', '');
        return $response['success'];
    }

    public function deleteUser(string $username): bool {
        $response = $this->request("/api/user/$username", 'DELETE');
        return $response['success'];
    }
}

function marzban_api_request(
    string $base_url,
    string $path,
    string $method = 'GET',
    ?string $token = null,
    $payload = null,
    array $headers = [],
    array $query = [],
    int $timeout = 20,
    int $connectTimeout = 10
): array {
    $url = rtrim($base_url, '/') . '/' . ltrim($path, '/');

    if (!empty($query) && is_array($query)) {
        $qs = http_build_query($query);
        if ($qs !== '') {
            $url .= (strpos($url, '?') !== false ? '&' : '?') . $qs;
        }
    }

    $curl = curl_init($url);
    $options = [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT        => $timeout,
        CURLOPT_CONNECTTIMEOUT => $connectTimeout,
        CURLOPT_FOLLOWLOCATION => true,
    ];

    $preparedHeaders = [];
    $hasContentType = false;
    foreach ($headers as $h) {
        if (stripos($h, 'content-type:') === 0) {
            $hasContentType = true;
        }
        $preparedHeaders[] = $h;
    }
    if ($token) {
        $preparedHeaders[] = 'Authorization: Bearer ' . $token;
    }
    $preparedHeaders[] = 'accept: application/json';

    $method = strtoupper($method);

    if ($payload !== null && $method === 'GET') {
        return [
            'success'       => false,
            'http_code'     => 0,
            'body'          => '',
            'data'          => null,
            'error'         => 'payload_not_allowed_for_get',
            'error_message' => 'Payload is not allowed for GET. Use query param.',
        ];
    }

    if ($payload !== null) {
        if (!is_string($payload)) {
            if (!$hasContentType) {
                $preparedHeaders[] = 'Content-Type: application/json';
            }
            $payload = json_encode($payload, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
        }
        if ($method === 'POST') {
            $options[CURLOPT_POST] = true;
        } else {
            $options[CURLOPT_CUSTOMREQUEST] = $method;
        }
        $options[CURLOPT_POSTFIELDS] = $payload;
    } else {
        if ($method === 'POST') {
            $options[CURLOPT_POST] = true;
        } elseif ($method !== 'GET') {
            $options[CURLOPT_CUSTOMREQUEST] = $method;
        }
    }

    $options[CURLOPT_HTTPHEADER] = $preparedHeaders;

    if (defined('DISABLE_SSL_VERIFY') && DISABLE_SSL_VERIFY) {
        $options[CURLOPT_SSL_VERIFYPEER] = false;
        $options[CURLOPT_SSL_VERIFYHOST] = 0;
    }

    curl_setopt_array($curl, $options);
    $body = curl_exec($curl);
    $http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE) ?: 0;
    $curl_error = ($body === false) ? curl_error($curl) : null;
    curl_close($curl);

    $decoded = ($body !== false && $body !== '') ? json_decode($body, true) : null;

    $success = ($curl_error === null) && $http_code >= 200 && $http_code < 300;
    $error_message = null;
    if (!$success) {
        if ($curl_error) {
            $error_message = $curl_error;
        } elseif (is_array($decoded)) {
            if (isset($decoded['detail'])) {
                $error_message = marzban_normalize_error_detail($decoded['detail']);
            } elseif (isset($decoded['message'])) {
                $error_message = marzban_normalize_error_detail($decoded['message']);
            }
        }
        if (!$error_message) {
            $error_message = 'HTTP ' . $http_code;
        }
        error_log(sprintf(
            'Marzban API error [%s %s] http=%d err=%s msg=%s',
            $method,
            $url,
            $http_code,
            $curl_error ?: '-',
            $error_message ?: '-'
        ));
    }

    return [
        'success'       => $success,
        'http_code'     => $http_code,
        'body'          => $body === false ? '' : (string)$body,
        'data'          => $decoded,
        'error'         => $curl_error,
        'error_message' => $error_message,
    ];
}

function marzban_request_admin_token(
    string $base_url,
    string $username,
    string $password,
    array $paths = ['/api/admins/token', '/api/admin/token']
): array {
    if (empty($paths)) {
        $paths = ['/api/admins/token'];
    }

    $normalizedPaths = [];
    foreach ($paths as $path) {
        if (!is_string($path) || $path === '') {
            continue;
        }
        $normalizedPaths[] = '/' . ltrim($path, '/');
    }
    if (empty($normalizedPaths)) {
        $normalizedPaths = ['/api/admins/token'];
    }

    $payload = http_build_query(
        ['username' => $username, 'password' => $password]
    );
    $headers = ['Content-Type: application/x-www-form-urlencoded'];

    $lastResponse = [
        'success'       => false,
        'token'         => '',
        'access_token'  => '',
        'data'          => null,
        'http_code'     => 0,
        'error'         => null,
        'error_message' => null,
    ];

    foreach ($normalizedPaths as $path) {
        $response = marzban_api_request(
            $base_url,
            $path,
            'POST',
            null,
            $payload,
            $headers
        );

        $tokenValue = '';
        if ($response['success'] && isset($response['data']) && is_array($response['data'])) {
            $rawToken = $response['data']['token'] ?? $response['data']['access_token'] ?? '';
            if (is_string($rawToken)) {
                $tokenValue = trim($rawToken);
            } elseif (is_scalar($rawToken)) {
                $tokenValue = trim((string)$rawToken);
            }
        }

        $result = [
            'success'       => $response['success'] && $tokenValue !== '',
            'token'         => $tokenValue,
            'access_token'  => $tokenValue,
            'data'          => $response['data'],
            'http_code'     => $response['http_code'],
            'error'         => $response['error'],
            'error_message' => $response['error_message'],
        ];

        if ($result['success']) {
            return $result;
        }

        $lastResponse = $result;

        if (!in_array($response['http_code'], [404, 405], true)) {
            return $lastResponse;
        }
    }

    return $lastResponse;
}

function marzban_normalize_error_detail($detail): string {
    if (is_string($detail)) {
        return $detail;
    }
    if (is_array($detail)) {
        if (isset($detail['msg'])) {
            return marzban_normalize_error_detail($detail['msg']);
        }
        $parts = [];
        foreach ($detail as $key => $value) {
            if (is_numeric($key)) {
                $parts[] = marzban_normalize_error_detail($value);
            } else {
                $parts[] = $key . ': ' . marzban_normalize_error_detail($value);
            }
        }
        return implode(', ', array_filter($parts));
    }
    if (is_object($detail)) {
        return marzban_normalize_error_detail((array)$detail);
    }
    return (string)$detail;
}

//////////////////////////////////////////////MARZBAN?//////////////////////////
function convertToBytes($from) {
    $units = ['B', 'KB', 'MB', 'GB', 'TB', 'PB'];
    $number = substr($from, 0, -2);
    $suffix = strtoupper(substr($from, -2));

    if (is_numeric(substr($suffix, 0, 1))) {
        return preg_replace('/[^\d]/', '', $from);
    }

    $exponent = array_flip($units)[$suffix] ?? null;
    if ($exponent === null) {
        return null;
    }

    return $number * (1024 ** $exponent);
}

function loginPanel($address, $username, $password) {
    return marzban_request_admin_token($address, $username, $password);
}

function marzban_get_user(string $username, string $token, string $url): array {
    return marzban_api_request($url, "/api/user/$username", 'GET', $token);
}

function marzban_get_subscription(string $username, string $token, string $url): array {
    return marzban_api_request($url, "/api/user/$username/subscription", 'GET', $token);
}

function marzban_request_with_retry(callable $cb, int $retries = 2, int $baseSleepMs = 250): array {
    $attempt = 0;
    $res = ['success' => false];
    do {
        $res = $cb();
        if (!empty($res['success'])) {
            return $res;
        }

        $code = (int)($res['http_code'] ?? 0);
        $shouldRetry = in_array($code, [0, 429, 500, 502, 503, 504], true);
        if (!$shouldRetry) {
            return $res;
        }

        $sleep = (int)($baseSleepMs * (2 ** $attempt));
        usleep($sleep * 1000);
        $attempt++;
    } while ($attempt <= $retries);

    return $res;
}

function createService($username, $data_limit, $expire, $proxies, $token, $url) {
    $payload = [
        'proxies' => $proxies,
        'expire' => $expire,
        'data_limit' => $data_limit,
        'username' => $username,
        'data_limit_reset_strategy' => 'no_reset'
    ];

    return marzban_request_with_retry(function () use ($url, $token, $payload) {
        return marzban_api_request($url, '/api/user', 'POST', $token, $payload);
    });
}

function tamdid($username, $data_limit, $expire, $proxies, $token, $url) {
    $payload = [
        'proxies' => $proxies,
        'expire' => $expire,
        'data_limit' => $data_limit,
        'username' => $username,
        'data_limit_reset_strategy' => 'no_reset'
    ];

    return marzban_request_with_retry(function () use ($url, $token, $username, $payload) {
        return marzban_api_request($url, "/api/user/$username", 'PUT', $token, $payload);
    });
}

function resetUser(string $username, string $token, string $url): array {
    return marzban_api_request(
        $url,
        "/api/user/$username/reset",
        'POST',
        $token,
        ''
    );
}

function deleteUser(string $username, string $token, string $url): array {
    return marzban_api_request(
        $url,
        "/api/user/$username",
        'DELETE',
        $token
    );
}

function buildProxies($list, $flow = 'on') {
    if (!is_string($list)) $list = '';
    $entries = preg_split('/[|\n]+/', $list);
    $proxies = [];

    foreach ($entries as $entry) {
        $entry = trim($entry);
        if ($entry === '') continue;

        $protocol = $entry;
        $options = [];

        if (preg_match('/^([a-z0-9_\-]+)\s*\((.+)\)$/i', $entry, $m)) {
            $protocol = strtolower(trim($m[1]));
            $options  = marzban_parse_proxy_options($m[2]);
        } else {
            $protocol = strtolower($protocol);
        }

        if ($protocol === 'vless' && $flow === 'on' && !isset($options['flow'])) {
            $options['flow'] = 'xtls-rprx-vision';
        }
        $proxies[$protocol] = isset($proxies[$protocol])
            ? array_merge($proxies[$protocol], $options)
            : $options;
    }

    if (empty($proxies)) {
        $proxies['vless'] = ($flow === 'on') ? ['flow' => 'xtls-rprx-vision'] : [];
    }
    return $proxies;
}

function marzban_parse_proxy_options(string $options): array {
    $result = [];
    foreach (explode(',', $options) as $pair) {
        $pair = trim($pair);
        if ($pair === '') continue;
        if (strpos($pair, '=') === false) { $result[$pair] = true; continue; }
        [$k,$v] = array_map('trim', explode('=', $pair, 2));
        if ($k === '') continue;
        $result[$k] = marzban_cast_option_value($v);
    }
    return $result;
}

function marzban_cast_option_value(string $value) {
    $l = strtolower($value);
    if ($l === 'true') return true;
    if ($l === 'false') return false;
    if ($l === 'null') return null;
    if (is_numeric($value)) return strpos($value, '.') !== false ? (float)$value : (int)$value;
    $n = strlen($value);
    if ($n >= 2 && (($value[0]==='"' && $value[$n-1]==='"') || ($value[0]==="'" && $value[$n-1]==="'")))
        return substr($value,1,-1);
    return $value;
}

// ------------------------------ Marzneshin helpers ------------------------------
function marzneshin_api_request(
    string $base_url,
    string $path,
    string $method = 'GET',
    ?string $token = null,
    $payload = null,
    array $headers = [],
    array $query = [],
    int $timeout = 20,
    int $connectTimeout = 10
): array {
    return marzban_api_request($base_url, $path, $method, $token, $payload, $headers, $query, $timeout, $connectTimeout);
}

function marzneshin_login(string $address, string $username, string $password): array {
    return marzban_request_admin_token($address, $username, $password);
}

function marzneshin_locate_user_from_response(array $data, string $username) {
    $items = $data['items'] ?? null;
    if (!is_array($items)) {
        return null;
    }
    $usernameLower = strtolower($username);
    foreach ($items as $item) {
        if (is_array($item) && isset($item['username']) && strtolower((string)$item['username']) === $usernameLower) {
            return $item;
        }
    }
    return null;
}

function marzneshin_compute_subscription_path(string $username, string $key): string {
    $username = trim($username);
    $key = trim($key);
    if ($username === '' || $key === '') {
        return '';
    }

    return '/sub/' . $username . '/' . $key . '/';
}

function marzneshin_normalize_user_payload($data): ?array {
    if (!is_array($data)) {
        return null;
    }

    $username = isset($data['username']) ? trim((string)$data['username']) : '';
    if ($username === '') {
        return null;
    }

    if (empty($data['subscription_url'])) {
        $path = marzneshin_compute_subscription_path($username, (string)($data['key'] ?? ''));
        if ($path !== '') {
            $data['subscription_url'] = $path;
        }
    }

    return $data;
}

function marzneshin_fetch_user(string $username, string $token, string $base_url): array {
    $directResponse = marzneshin_api_request(
        $base_url,
        '/api/users/' . rawurlencode($username),
        'GET',
        $token
    );

    if ($directResponse['success']) {
        $normalized = marzneshin_normalize_user_payload($directResponse['data'] ?? null);
        if ($normalized !== null) {
            $directResponse['data'] = $normalized;
            return $directResponse;
        }

        $directResponse['success'] = false;
        $directResponse['error_message'] = $directResponse['error_message'] ?: 'Unexpected response format from panel.';
        if (!($directResponse['http_code'] ?? 0)) {
            $directResponse['http_code'] = 500;
        }
        return $directResponse;
    }

    $fallbackCodes = [404, 405];
    $shouldFallback = in_array((int)($directResponse['http_code'] ?? 0), $fallbackCodes, true);

    if (!$shouldFallback) {
        return $directResponse;
    }

    $listResponse = marzneshin_api_request(
        $base_url,
        '/api/users',
        'GET',
        $token,
        null,
        [],
        ['page' => 1, 'size' => 1, 'username' => $username]
    );

    if ($listResponse['success']) {
        $user = marzneshin_locate_user_from_response($listResponse['data'] ?? [], $username);
        if ($user) {
            $normalized = marzneshin_normalize_user_payload($user);
            if ($normalized !== null) {
                $listResponse['data'] = $normalized;
                return $listResponse;
            }
        }

        $listResponse['success'] = false;
        $listResponse['http_code'] = $listResponse['http_code'] ?: 404;
        $listResponse['error_message'] = $listResponse['error_message'] ?: 'User not found';
        return $listResponse;
    }

    if (($listResponse['http_code'] ?? 0) && !($directResponse['http_code'] ?? 0)) {
        return $listResponse;
    }

    return $directResponse;
}

function marzneshin_get_user(string $username, string $token, string $base_url): array {
    return marzneshin_fetch_user($username, $token, $base_url);
}

function marzneshin_build_user_payload(
    string $username,
    int $data_limit,
    int $expire_time,
    array $service_ids,
    array $extra = [],
    bool $includeUsername = true
): array {
    $normalized_ids = array_values(array_unique(array_map('intval', marzneshin_parse_service_ids($service_ids))));

    $payload = [
        'data_limit' => max(0, $data_limit),
        'data_limit_reset_strategy' => $extra['data_limit_reset_strategy'] ?? 'no_reset',
        'service_ids' => $normalized_ids,
    ];

    if ($includeUsername) {
        $payload['username'] = $username;
    }

    $expire_strategy = $extra['expire_strategy'] ?? '';
    if ($expire_time > 0) {
        if ($expire_strategy === '') {
            $expire_strategy = 'fixed_date';
        }

        if ($expire_strategy === 'fixed_date') {
            $payload['expire_strategy'] = 'fixed_date';
            $payload['expire_date'] = gmdate('c', $expire_time);
        } elseif ($expire_strategy === 'start_on_first_use') {
            $payload['expire_strategy'] = 'start_on_first_use';
            if (isset($extra['usage_duration'])) {
                $payload['usage_duration'] = (int)$extra['usage_duration'];
            }
        } else {
            $payload['expire_strategy'] = $expire_strategy;
        }
    } elseif ($expire_strategy !== '') {
        $payload['expire_strategy'] = $expire_strategy;
    }

    if (array_key_exists('data_limit_reset_strategy', $extra) && ($extra['data_limit_reset_strategy'] ?? '') === '') {
        unset($payload['data_limit_reset_strategy']);
    }

    foreach (['note', 'activation_deadline', 'owner_username'] as $key) {
        if (isset($extra[$key]) && $extra[$key] !== '') {
            $payload[$key] = $extra[$key];
        }
    }

    if (isset($extra['custom_payload']) && is_array($extra['custom_payload'])) {
        $payload = array_merge($payload, $extra['custom_payload']);
    }

    return $payload;
}

function marzneshin_create_user(
    string $username,
    int $data_limit,
    int $expire_time,
    array $service_ids,
    string $token,
    string $base_url,
    array $extra = []
): array {
    $payload = marzneshin_build_user_payload($username, $data_limit, $expire_time, $service_ids, $extra, true);

    $response = marzban_request_with_retry(function () use ($base_url, $token, $payload) {
        return marzneshin_api_request(
            $base_url,
            '/api/users',
            'POST',
            $token,
            $payload
        );
    });

    if (!$response['success']) {
        return $response;
    }

    $normalized = marzneshin_normalize_user_payload($response['data'] ?? null);
    if ($normalized !== null) {
        $response['data'] = $normalized;
        return $response;
    }

    $fetched = marzneshin_fetch_user($username, $token, $base_url);
    if ($fetched['success']) {
        return $fetched;
    }

    $response['success'] = false;
    $response['error_message'] = $fetched['error_message'] ?? $response['error_message'] ?? 'Failed to retrieve user details from panel.';
    if (!empty($fetched['http_code'])) {
        $response['http_code'] = $fetched['http_code'];
    }

    return $response;
}

function marzneshin_update_user(
    string $username,
    int $data_limit,
    int $expire_time,
    array $service_ids,
    string $token,
    string $base_url,
    array $extra = []
): array {
    $payload = marzneshin_build_user_payload($username, $data_limit, $expire_time, $service_ids, $extra, false);

    $response = marzban_request_with_retry(function () use ($base_url, $token, $username, $payload) {
        return marzneshin_api_request(
            $base_url,
            '/api/users/' . rawurlencode($username),
            'PUT',
            $token,
            $payload
        );
    });

    if (!$response['success']) {
        return $response;
    }

    $normalized = marzneshin_normalize_user_payload($response['data'] ?? null);
    if ($normalized !== null) {
        $response['data'] = $normalized;
        return $response;
    }

    $fetched = marzneshin_fetch_user($username, $token, $base_url);
    if ($fetched['success']) {
        return $fetched;
    }

    $response['success'] = false;
    $response['error_message'] = $fetched['error_message'] ?? $response['error_message'] ?? 'Failed to retrieve updated user details from panel.';
    if (!empty($fetched['http_code'])) {
        $response['http_code'] = $fetched['http_code'];
    }

    return $response;
}

function marzneshin_reset_user(string $username, string $token, string $base_url): array {
    return marzneshin_api_request(
        $base_url,
        "/api/users/" . rawurlencode($username) . '/reset',
        'POST',
        $token,
        ''
    );
}

function marzneshin_delete_user(string $username, string $token, string $base_url): array {
    return marzneshin_api_request(
        $base_url,
        "/api/users/" . rawurlencode($username),
        'DELETE',
        $token
    );
}

function marzneshin_parse_service_ids($value): array {
    if (is_array($value)) {
        $parts = $value;
    } else {
        $parts = preg_split('/[|,\s]+/', (string)$value);
    }
    $ids = [];
    foreach ($parts as $part) {
        $part = trim((string)$part);
        if ($part === '' || !ctype_digit($part)) {
            continue;
        }
        $value = (int)$part;
        if ($value <= 0) {
            continue;
        }
        $ids[] = $value;
    }
    return array_values(array_unique($ids));
}

function marzneshin_server_service_ids(array $server): array {
    return marzneshin_parse_service_ids($server['marzneshin_service_ids'] ?? '');
}

function marzneshin_resolve_subscription_url(string $base_url, string $subscription_path): string {
    if ($subscription_path === '') {
        return '';
    }
    if (preg_match('/^https?:\/\//i', $subscription_path)) {
        return $subscription_path;
    }
    return rtrim($base_url, '/') . '/' . ltrim($subscription_path, '/');
}
//////////////////////////////////////////////MARZBAN?//////////////////////////
//-----------------------------------------------------------------------------
// Read update safely and populate commonly used fields without notices
$rawUpdate = file_get_contents('php://input');
$update = json_decode($rawUpdate);
$update2 = json_decode($rawUpdate, true);

// Convenient shortcuts (guarded)
$message    = isset($update->message) ? $update->message : null;
$callback   = isset($update->callback_query) ? $update->callback_query : null;
$inline_q   = isset($update->inline_query) ? $update->inline_query : null;

$from_id    = isset($message->from->id) ? $message->from->id : null;
$chat_id    = isset($message->chat->id) ? $message->chat->id : null;
$membercall = isset($callback->id) ? $callback->id : null;
$message_id = isset($message->message_id) ? $message->message_id : null;
$name       = isset($message->from->first_name) ? $message->from->first_name : null;
$naeme2     = isset($callback->from->first_name) ? $callback->from->first_name : null;
$last_name  = isset($message->from->last_name) ? $message->from->last_name : null;
$username   = isset($message->from->username) ? $message->from->username : null;
$tc         = isset($message->chat->type) ? $message->chat->type : null;
$contact    = isset($message->contact) ? $message->contact : null;
$text       = isset($message->text) ? $message->text : null;
$caption    = isset($message->caption) ? $message->caption : null;
$forward_chat_username = isset($message->forward_from_chat->username) ? $message->forward_from_chat->username : null;
$chatid     = isset($callback->message->chat->id) ? $callback->message->chat->id : null;
$data       = isset($callback->data) ? $callback->data : null;
$messageid  = isset($callback->message->message_id) ? $callback->message->message_id : null;
$fromid     = isset($inline_q->from->id) ? $inline_q->from->id : null;
$inline_query = $inline_q; // keep name compatibility
$queryid    = isset($inline_q->id) ? $inline_q->id : null;
$messup     = isset($message->message_id) ? $message->message_id : null;
$rpto       = isset($message->reply_to_message->forward_from->id) ? $message->reply_to_message->forward_from->id : null;

// photo file_id (largest size if available)
$photoid = null;
if (isset($update2['message']['photo']) && is_array($update2['message']['photo']) && count($update2['message']['photo']) > 0) {
    $lastIndex = count($update2['message']['photo']) - 1;
    $photoid = $update2['message']['photo'][$lastIndex]['file_id'] ?? null;
}

// contact details (if present)
$contactid  = isset($contact->user_id) ? $contact->user_id : null;
$contactnum = isset($contact->phone_number) ? $contact->phone_number : null;

// Make available for other includes that expect this global
$GLOBALS['membercall'] = $membercall;

// استفاده از prepared statements برای جلوگیری از SQL Injection
$user = null;
if (isset($from_id)) {
    $stmt = $connect->prepare("SELECT * FROM user WHERE id = ? LIMIT 1");
    $stmt->bind_param("s", $from_id);
    $stmt->execute();
    $user = $stmt->get_result()->fetch_assoc();
    $stmt->close();
}

$user2 = null;
if (isset($chatid)) {
    $stmt = $connect->prepare("SELECT * FROM user WHERE id = ? LIMIT 1");
    $stmt->bind_param("s", $chatid);
    $stmt->execute();
    $user2 = $stmt->get_result()->fetch_assoc();
    $stmt->close();
}

// تابع عضویت و لینک کانال از اینجا حذف و به index.php منتقل شد

//-----------------------------------------------------------------------------
$start = json_encode(['keyboard'=>[
    [['text'=>"🪪اکانت تست"]],//,['text'=>"🎁 کد تخفیف"]],
    [['text'=>'👛 کیف پول']],
    //[['text'=>"🎁 دعوت دوستان"]],
    [['text'=>"♻️ تمدید سرویس"],['text'=>"🗄 سرویس ها"],['text'=>"🛒 خرید سرویس"]],
    [['text'=>"📋 تعرفه سرویس ها"]],
    [['text'=>"👤 حساب کاربری"],['text'=>"☎️ پشتیبانی"]]
],'resize_keyboard'=>true]);
$charge = json_encode(["keyboard"=>[
    [['text'=>"پرداخت ➕"],['text'=>"محاسبه 🖥"]],
   [['text'=>"🔙 منو اصلی"]],
],'resize_keyboard'=>true]);
$withdraw= json_encode(["keyboard"=>[
    [['text'=>"برداشت 📥"],['text'=>"ثبت کیف پول 💼"]],
    [['text'=>'تغییر کیف پول ⚙️']],
   [['text'=>"🔙 منو اصلی"]],
],'resize_keyboard'=>true]);
$tarakoneshha= json_encode(["keyboard"=>[
    [['text'=>"ثبت کیف پول 💼"]],
    [['text'=>"💹 تاریخچه"]],
   [['text'=>"🔙 منو اصلی"]],
],'resize_keyboard'=>true]);
$history=json_encode(["keyboard"=>[
    [['text'=>"تاریخچه سرمایه گذاری"]],
    [['text'=>"تاریخچه برداشت"]],
   [['text'=>"🔙 منو اصلی"]],
],'resize_keyboard'=>true]);
$panel=json_encode(["keyboard"=>[

[['text'=>"آمار"],['text'=>"پیام همگانی"]],
    [['text'=>"🔙 منو اصلی"]],
],'resize_keyboard'=>true]);
//▪▪▪▪▪▪▪▪▪▪▪▪//
$back=json_encode(['keyboard'=>[
    [['text'=>"🔙 منو اصلی"]],
   ],'resize_keyboard'=>true]);
   $backp=json_encode(['keyboard'=>[
    [['text'=>"بازگشت به پنل"]],
   ],'resize_keyboard'=>true]);
$panel=json_encode(['keyboard'=>[
       [['text'=>"اضافه کردن سرور"],['text'=>"مدیریت سرورها"]],
       [['text'=>"مدیریت تعرفه"],['text'=>"افزودن تعرفه"]],
       [['text'=>"⚙️ مدیریت قیمت‌ها"]], // <-- دکمه جدید
       [['text'=>"آمار"],['text'=>"پیام همگانی"]],
       [['text'=>"حذف سرویس کاربر"]],
      [['text'=>"کاهش موجودی"],['text'=>"افزایش موجودی"]],
       [['text'=>"دریافت اطلاعات کاربر"],['text'=>"خاموش/روشن اد اجباری"]],
       [['text'=>"تغییر شماره کارت"]],
    [['text'=>"🔙 منو اصلی"]],
   ],'resize_keyboard'=>true]); 
   // دکمه جوین از اینجا حذف و به index.php منتقل شد
?>

